/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.donnees;

import fr.histoiremondiale.histoire.donnees.LimesOrdonne;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.util.ArrayList;
import java.util.List;

public class Pourtour {
    private int id;
    private List<LimesOrdonne> limesOrdonnes;
    private PointSphere centreCercleLimite;
    private double cosCercleLimite;

    public Pourtour(int n, List<LimesOrdonne> list, PointSphere pointSphere, double d) {
        this.id = n;
        this.limesOrdonnes = list;
        this.centreCercleLimite = pointSphere;
        this.cosCercleLimite = d;
    }

    public List<PointSphere> points() {
        int n = 0;
        for (LimesOrdonne limesOrdonne : this.limesOrdonnes) {
            n += limesOrdonne.limes().points().size();
        }
        ArrayList<PointSphere> arrayList = new ArrayList<PointSphere>(n);
        for (LimesOrdonne limesOrdonne : this.limesOrdonnes) {
            List<PointSphere> list = limesOrdonne.limes().points();
            if (limesOrdonne.sensNormal()) {
                arrayList.addAll(list);
                continue;
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                arrayList.add(list.get(i));
            }
        }
        return arrayList;
    }

    public int id() {
        return this.id;
    }

    public List<LimesOrdonne> limesOrdonnes() {
        return this.limesOrdonnes;
    }

    public PointSphere centreCercleLimite() {
        return this.centreCercleLimite;
    }

    public double cosCercleLimite() {
        return this.cosCercleLimite;
    }
}

