/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire;

import fr.histoiremondiale.histoire.DonneesHistoriques;
import fr.histoiremondiale.histoire.donnees.Civilisation;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.igraphique.donnees.InfosParagrapheNavig;
import fr.histoiremondiale.histoire.stockage.AccesDonneesIGraphique;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.Observable;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DonneesIGraphique
extends Observable {
    private List<InfosParagrapheNavig> paragraphes;
    private Map<Territoire, PointSphere> centresTextesTerritoires;
    private boolean donneesTraceCarteModifiees;
    private Map<Territoire, Double> loupesTextesTerritories;
    private AccesDonneesIGraphique accesDonneesIGraphique;

    public DonneesIGraphique(AccesDonneesIGraphique accesDonneesIGraphique, DonneesHistoriques donneesHistoriques) {
        long l = System.currentTimeMillis();
        System.out.println("\t\tD\u00e9but du chargement des donn\u00e9es pour l'interface graphique");
        try {
            this.accesDonneesIGraphique = accesDonneesIGraphique;
            long l2 = System.currentTimeMillis();
            this.paragraphes = this.accesDonneesIGraphique.chargerInfosParagraphesNavig(donneesHistoriques);
            long l3 = System.currentTimeMillis();
            System.out.println("\t\t\tfin du chargement des paragraphes en : " + (l3 - l2) + " ms");
            try {
                this.centresTextesTerritoires = this.accesDonneesIGraphique.chargerPositionTextes(donneesHistoriques);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Erreur lors du chargement des positions des textes d\u00e9plac\u00e9s.\nVous pouvez essayer de d\u00e9truire le fichier de configuration contenant les positions modifi\u00e9es (vos modifications seront perdues).", throwable);
            }
            try {
                this.loupesTextesTerritories = this.accesDonneesIGraphique.chargerValeursLoupeTerritoire(donneesHistoriques);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Erreur lors du chargement des niveaux de grossissement limite de visibilit\u00e9 des textes.\nVous pouvez essayer de d\u00e9truire le fichier de configuration contenant les niveaux modifi\u00e9s (vos modifications seront perdues).", throwable);
            }
            l3 = System.currentTimeMillis();
            l3 = System.currentTimeMillis();
            System.out.println("\t\tfin du chargement des donn\u00e9es pour l'interface graphique en : " + (l3 - l) + " ms.");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Erreur lors du chargement des donn\u00e9es pour l'interface graphique", iOException);
        }
    }

    public synchronized InfosParagrapheNavig paragrapheParAncre(String string) {
        if (string == null) {
            throw new IllegalArgumentException("La civilisation (ancre) devrait \u00eatre renseign\u00e9e");
        }
        for (InfosParagrapheNavig infosParagrapheNavig : this.paragraphes) {
            if (!string.equals(infosParagrapheNavig.ancre())) continue;
            return infosParagrapheNavig;
        }
        return null;
    }

    public synchronized InfosParagrapheNavig paragrapheParCriteres(Civilisation civilisation, Integer n) {
        if (civilisation == null) {
            throw new IllegalArgumentException("La civilisation devrait \u00eatre renseign\u00e9e");
        }
        for (InfosParagrapheNavig infosParagrapheNavig : this.paragraphes) {
            if (infosParagrapheNavig.civilisation() == null || !infosParagrapheNavig.civilisation().equals(civilisation) || !infosParagrapheNavig.anneeEstDansPeriodeCouverte(n)) continue;
            return infosParagrapheNavig;
        }
        return null;
    }

    public synchronized List<InfosParagrapheNavig> paragraphesParCriteres(Civilisation civilisation, Integer n) {
        ArrayList<InfosParagrapheNavig> arrayList = new ArrayList<InfosParagrapheNavig>();
        for (InfosParagrapheNavig infosParagrapheNavig : this.paragraphes) {
            if (civilisation != null && !civilisation.equals(infosParagrapheNavig.civilisation()) || n != null && !infosParagrapheNavig.anneeEstDansPeriodeCouverte(n)) continue;
            arrayList.add(infosParagrapheNavig);
        }
        return arrayList;
    }

    public synchronized PointSphere centreTexteTerritoire(Territoire territoire) {
        PointSphere pointSphere = this.centresTextesTerritoires.get(territoire);
        return pointSphere != null ? pointSphere : territoire.pointCentral();
    }

    public synchronized void modifCentreTexteTerritoire(Territoire territoire, PointSphere pointSphere) {
        this.centresTextesTerritoires.put(territoire, pointSphere);
        this.donneesTraceCarteModifiees = true;
        this.avertirObservateurs("centreTexteTerritoire");
    }

    public synchronized void reinitialiserDonneesModifiees() {
        this.centresTextesTerritoires.clear();
        this.loupesTextesTerritories.clear();
        this.donneesTraceCarteModifiees = true;
        this.avertirObservateurs("centreTexteTerritoire");
        this.avertirObservateurs("loupeTerritoire");
    }

    public synchronized double loupeTerritoire(Territoire territoire) {
        Double d = this.loupesTextesTerritories.get(territoire);
        return d != null ? d.doubleValue() : territoire.valLoupeLimiteAff();
    }

    public synchronized void modifLoupeTerritoire(Territoire territoire, double d) {
        this.loupesTextesTerritories.put(territoire, d);
        this.donneesTraceCarteModifiees = true;
        this.avertirObservateurs("loupeTerritoire");
    }

    public synchronized List<InfosParagrapheNavig> paragraphes() {
        return this.paragraphes;
    }

    public synchronized Map<Territoire, PointSphere> centresTextesTerritoires() {
        return new HashMap<Territoire, PointSphere>(this.centresTextesTerritoires);
    }

    public synchronized boolean donneesTraceCarteModifiees() {
        boolean bl = this.donneesTraceCarteModifiees;
        this.donneesTraceCarteModifiees = false;
        return bl;
    }

    public synchronized Map<Territoire, Double> loupesTextesTerritoires() {
        return new HashMap<Territoire, Double>(this.loupesTextesTerritories);
    }
}

