/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique;

import fr.histoiremondiale.histoire.EtatAppli;
import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.RessourcesAppli;
import fr.histoiremondiale.histoire.igraphique.tracercartes.GestTracerCartes;
import fr.histoiremondiale.histoire.igraphique.tracercartes.InfosTracerImage;
import fr.histoiremondiale.histoire.utiles.exceptions.Exceptions;
import fr.histoiremondiale.histoire.utiles.math.CoordSphere;
import fr.histoiremondiale.histoire.utiles.math.PointPlan;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;

public class PanCarte
extends JPanel
implements Observer {
    public static final Color COUL_TERRES = new Color(0xFFFFC0);
    public static final Color COUL_MERS = new Color(0xC0FFFF);
    public static final Color COUL_FLEUVES = new Color(64);
    public static final int ANGLE_CARTE = 60;
    public static final double COEFFT_CARTE = 2.0 * Math.tan(Math.toRadians(30.0));
    private GestTracerCartes gestTracerCartes = GestTracerCartes.creerInstance(this);

    public PanCarte() {
        HistoireMondiale.instance().etat().addObserver(this);
        HistoireMondiale.instance().donneesIGraphique().addObserver(this);
    }

    public GestTracerCartes gestTracerCartes() {
        return this.gestTracerCartes;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        InfosTracerImage infosTracerImage = this.gestTracerCartes.infosImageActuelle();
        BufferedImage bufferedImage = infosTracerImage.ancImg.image;
        if (bufferedImage == null) {
            this.recreerCarte();
        } else {
            Throwable throwable;
            PointPlan pointPlan = this.posImgCarteVersPosPanneau(0, 0);
            graphics.drawImage(bufferedImage, (int)pointPlan.x(), (int)pointPlan.y(), this);
            if (HistoireMondiale.instance().etat().symboleAttenteTracer() && infosTracerImage.perimee()) {
                graphics.drawImage(RessourcesAppli.imageIcone(RessourcesAppli.ICONE_PLUME), 0, 0, null);
            }
            if ((throwable = infosTracerImage.ancImg.erreur) != null) {
                int n = 0;
                graphics.drawString("Erreur lors de la g\u00e9n\u00e9ration de la carte", 1, ++n * 20);
                graphics.drawString(Exceptions.extraireMessagesErreur(throwable), 1, ++n * 20);
            }
        }
    }

    public PointPlan posPanneauVersPosImgCarte(int n, int n2) {
        InfosTracerImage infosTracerImage = this.gestTracerCartes.infosImageActuelle();
        BufferedImage bufferedImage = infosTracerImage.ancImg.image;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = n + (n3 - this.getWidth()) / 2;
        int n6 = n2 + (n4 - this.getHeight()) / 2;
        return new PointPlan(n5, n6);
    }

    public PointPlan posImgCarteVersPosPanneau(int n, int n2) {
        InfosTracerImage infosTracerImage = this.gestTracerCartes.infosImageActuelle();
        BufferedImage bufferedImage = infosTracerImage.ancImg.image;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        int n5 = n - (n3 - this.getWidth()) / 2;
        int n6 = n2 - (n4 - this.getHeight()) / 2;
        return new PointPlan(n5, n6);
    }

    public PointSphere posPanneauVersPosSphere(int n, int n2) {
        InfosTracerImage infosTracerImage = this.gestTracerCartes.infosImageActuelle();
        BufferedImage bufferedImage = infosTracerImage.ancImg.image;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        PointSphere pointSphere = infosTracerImage.ancImg.demande.ptCentrePlan;
        double d = infosTracerImage.ancImg.demande.loupe;
        PointPlan pointPlan = this.posPanneauVersPosImgCarte(n, n2);
        return CoordSphere.coordPlanVersSphere(pointPlan, pointSphere, CoordSphere.matChgtPlanVersSphere(pointSphere), n3, n4, d);
    }

    public BufferedImage imageCarteActuelle() {
        return this.gestTracerCartes.infosImageActuelle().ancImg.image;
    }

    public void recreerCarte() {
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        EtatAppli etatAppli = histoireMondiale.etat();
        this.gestTracerCartes.demanderNouvelleCarte(etatAppli.annee(), etatAppli.fleuvesAffiches(), etatAppli.meridiensParallelesAffiches(), etatAppli.ptCentralCarte(), this.getWidth(), this.getHeight(), etatAppli.loupe(), COUL_MERS, COUL_TERRES, COUL_FLEUVES);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.recreerCarte();
    }
}

