/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique;

import fr.histoiremondiale.histoire.EtatAppli;
import fr.histoiremondiale.histoire.HistoireMondiale;
import fr.histoiremondiale.histoire.RessourcesAppli;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.donnees.TexteTerritoire;
import fr.histoiremondiale.histoire.igraphique.PanCarte;
import fr.histoiremondiale.histoire.igraphique.PanNavigateur;
import fr.histoiremondiale.histoire.igraphique.composants.BarreDefilement;
import fr.histoiremondiale.histoire.igraphique.composants.EltMenuCoche;
import fr.histoiremondiale.histoire.igraphique.composants.GlissiereDates;
import fr.histoiremondiale.histoire.igraphique.composants.Texte;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.border.BevelBorder;

public class FenPrincipale
extends JFrame
implements Observer,
MouseWheelListener {
    public static final double PROPORTION_SEPARATEUR_DEFAUT = 0.66;
    public static final int MULTIPLICATEUR_ESPACE = (int)Math.pow(10.0, 2.0);
    public JMenu menu_fichier;
    public JMenuItem eltmenu_ficReinitValeurs;
    public JMenuItem eltmenu_ficExporterCarte;
    public JMenuItem eltmenu_ficExporterCarteEtParagraphe;
    public JMenuItem eltmenu_ficVisualiserParagraphe;
    public JMenuItem eltmenu_ficQuitter;
    public JMenu menu_navigation;
    public JMenuItem eltmenu_navigChoisirCivilisation;
    public JMenuItem eltmenu_navigChoisirDate;
    public JMenuItem eltmenu_navigChoisirCentre;
    public JMenu menu_affichage;
    public JMenuItem eltmenu_affFleuvesVisibles;
    public JMenuItem eltmenu_affChoixLoupe;
    public JMenu menu_options;
    public JMenu menu_deplacements;
    public JMenu menu_deplAnnees;
    public JMenu menu_deplEspace;
    public JMenu menu_parametres;
    public JMenuItem eltmenu_optInfobullesCarte;
    public JMenuItem eltmenu_optSymboleTracer;
    public JMenuItem eltmenu_optTexteSurvolFondClair;
    public JMenuItem eltmenu_affMeridiensParallelesVisibles;
    public JMenuItem eltmenu_optSimpleClicFermerParagraphes;
    public JMenuItem eltmenu_optMoletteGlisseDeUn;
    public JMenuItem eltmenu_optAffParagraphesHtmlGeneres;
    public JMenu menu_aide;
    public JMenuItem eltmenu_aidePresentation;
    public JMenuItem eltmenu_aideAPropos;
    public JPopupMenu menuctx_deplAnnees;
    public JPopupMenu menuctx_deplEspace;
    private JSplitPane sp_panneauDeuxCotes;
    public PanNavigateur p_navigateur;
    public PanCarte p_carte;
    private Box p_infos;
    public Texte txt_pointCentral;
    public Texte txt_annee;
    public JLabel txt_loupe;
    public JLabel txt_infosTerritoireSurvole;
    public JLabel txt_infosRoiTerritoireSurvole;
    public JButton bt_loupe;
    public BarreDefilement defil_longitudes;
    public BarreDefilement defil_latitudes;
    public GlissiereDates defil_annees;

    public FenPrincipale() {
        super("Histoire");
        double d;
        double d2;
        System.out.println("\t\tD\u00e9but de la construction de la fen\u00eatre");
        long l = System.currentTimeMillis();
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        EtatAppli etatAppli = histoireMondiale.etat();
        this.setIconImage(RessourcesAppli.imageIcone(RessourcesAppli.ICONE_APPLI_32));
        this.txt_pointCentral = new Texte(" Centre : ##valCh## ", etatAppli, "ptCentralCarte");
        this.txt_annee = new Texte(" Date : ##valCh## ", etatAppli, "annee");
        this.txt_loupe = new Texte(" Loupe : ##valFS##x", etatAppli, "loupe");
        this.txt_infosTerritoireSurvole = new JLabel();
        this.txt_infosRoiTerritoireSurvole = new JLabel();
        this.txt_infosTerritoireSurvole.setOpaque(true);
        this.txt_infosRoiTerritoireSurvole.setOpaque(true);
        this.txt_infosTerritoireSurvole.setVisible(false);
        this.txt_infosRoiTerritoireSurvole.setVisible(false);
        this.txt_pointCentral.setBorder(new BevelBorder(1));
        this.txt_annee.setBorder(new BevelBorder(1));
        this.txt_loupe.setBorder(new BevelBorder(1));
        this.p_infos = new Box(2);
        this.p_infos.add(this.txt_pointCentral);
        this.p_infos.add(Box.createHorizontalStrut(5));
        this.p_infos.add(this.txt_annee);
        this.p_infos.add(Box.createHorizontalStrut(5));
        this.p_infos.add(this.txt_loupe);
        this.p_infos.add(Box.createHorizontalGlue());
        this.p_infos.add(this.txt_infosTerritoireSurvole);
        this.p_infos.add(this.txt_infosRoiTerritoireSurvole);
        PointSphere pointSphere = etatAppli.ptCentralCarte();
        this.defil_longitudes = new BarreDefilement(etatAppli, "longitude", "deplEspace", "##val##\u00b0", 0, (int)(-pointSphere.longitude()), 60, -180, 241, MULTIPLICATEUR_ESPACE);
        this.defil_longitudes.addMouseWheelListener(this);
        this.defil_latitudes = new BarreDefilement(etatAppli, "latitude", "deplEspace", "##val##\u00b0", 1, (int)(-pointSphere.latitude()), 60, -90, 150, true, MULTIPLICATEUR_ESPACE);
        this.defil_latitudes.addMouseWheelListener(this);
        int n = (int)this.defil_longitudes.getPreferredSize().getHeight() - 2;
        this.bt_loupe = new JButton(RessourcesAppli.icone(RessourcesAppli.ICONE_LOUPE));
        this.bt_loupe.setToolTipText("Clic gauche pour augmenter, clic droit pour diminuer");
        this.bt_loupe.setPreferredSize(new Dimension(n, n));
        this.bt_loupe.setMaximumSize(new Dimension(n, n));
        int n2 = etatAppli.annee();
        int n3 = -3100;
        int n4 = 2000;
        int n5 = EtatAppli.VALS_PAS_ANNEES[HistoireMondiale.instance().etat().iDeplAnnees()];
        this.defil_annees = new GlissiereDates(etatAppli, "annee", "deplAnnees", n3, n4, n2, n5);
        this.defil_annees.addMouseWheelListener(this);
        Box box = new Box(0);
        box.add(this.defil_annees);
        this.sp_panneauDeuxCotes = new JSplitPane(1, false, new JPanel(), new JPanel());
        this.sp_panneauDeuxCotes.setOneTouchExpandable(true);
        this.sp_panneauDeuxCotes.setResizeWeight(etatAppli.posSeparateurCarteNavig());
        this.sp_panneauDeuxCotes.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FenPrincipale.this.sp_panneauDeuxCotes.setResizeWeight(FenPrincipale.this.posSeparateurPanneaux());
            }
        });
        Box box2 = new Box(1);
        box2.add(box);
        box2.add(this.p_infos);
        this.setDefaultCloseOperation(0);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension.getWidth() / dimension.getHeight() >= 1.33) {
            d2 = 0.75 * dimension.getHeight();
            d = 1.33 * d2;
        } else {
            d = 0.75 * dimension.getWidth();
            d2 = d / 1.33;
        }
        this.setSize(new Dimension((int)d, (int)d2));
        this.setMinimumSize(new Dimension(250, 150));
        int n6 = (int)(dimension.getWidth() - d) / 2;
        int n7 = (int)(dimension.getHeight() - d2) / 2;
        this.setLocation(n6, n7);
        JMenuBar jMenuBar = this.creerMenus();
        this.setJMenuBar(jMenuBar);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.sp_panneauDeuxCotes, "Center");
        this.getContentPane().add((Component)box2, "South");
        this.majInfosTerritoireSurvole();
        etatAppli.addObserver(this);
        this.setExtendedState(6);
        long l2 = System.currentTimeMillis();
        System.out.println("\t\tFin de la construction de la fen\u00eatre en : " + (l2 - l) + "ms.");
    }

    public void finirInitialisation() {
        System.out.println("d\u00e9but de la fin de l'initialisation");
        long l = System.currentTimeMillis();
        HistoireMondiale histoireMondiale = HistoireMondiale.instance();
        EtatAppli etatAppli = histoireMondiale.etat();
        long l2 = System.currentTimeMillis();
        this.p_navigateur = new PanNavigateur();
        long l3 = System.currentTimeMillis();
        System.out.println("\tFin de la construction du panneau navigateur en : " + (l3 - l2) + " ms.");
        l2 = System.currentTimeMillis();
        this.p_carte = new PanCarte();
        JPanel jPanel = new JPanel(new BorderLayout());
        Box box = new Box(2);
        box.add(this.defil_longitudes);
        box.add(this.bt_loupe);
        jPanel.add((Component)this.p_carte, "Center");
        jPanel.add((Component)box, "South");
        jPanel.add((Component)this.defil_latitudes, "East");
        l3 = System.currentTimeMillis();
        System.out.println("\tFin de la construction du panneau carte en : " + (l3 - l2) + " ms.");
        this.sp_panneauDeuxCotes.setLeftComponent(jPanel);
        this.sp_panneauDeuxCotes.setRightComponent(this.p_navigateur);
        this.sp_panneauDeuxCotes.setDividerLocation(etatAppli.posSeparateurCarteNavig());
        l3 = System.currentTimeMillis();
        System.out.println("Fin de l'assemblage de la fen\u00eatre principale en : " + (l3 - l) + " ms.");
    }

    private JMenuBar creerMenus() {
        EtatAppli etatAppli = HistoireMondiale.instance().etat();
        JMenuBar jMenuBar = new JMenuBar();
        this.menu_fichier = this.menu("Fichier", 70);
        jMenuBar.add(this.menu_fichier);
        this.eltmenu_ficReinitValeurs = new JMenuItem("Revenir aux valeurs initiales");
        this.menu_fichier.add(this.eltmenu_ficReinitValeurs);
        this.menu_fichier.addSeparator();
        this.eltmenu_ficExporterCarte = new JMenuItem("Sauvegarder la carte dans...");
        this.menu_fichier.add(this.eltmenu_ficExporterCarte);
        this.eltmenu_ficExporterCarteEtParagraphe = new JMenuItem("Sauvegarder le paragraphe dans...");
        this.menu_fichier.add(this.eltmenu_ficExporterCarteEtParagraphe);
        this.eltmenu_ficVisualiserParagraphe = new JMenuItem("Visualiser un paragraphe sauvegard\u00e9...");
        this.menu_fichier.add(this.eltmenu_ficVisualiserParagraphe);
        this.menu_fichier.addSeparator();
        this.eltmenu_ficQuitter = new JMenuItem("Quitter");
        this.menu_fichier.add(this.eltmenu_ficQuitter);
        this.menu_navigation = this.menu("Navigation", 78);
        jMenuBar.add(this.menu_navigation);
        this.eltmenu_navigChoisirCivilisation = new JMenuItem("Choisir une civilisation...");
        this.menu_navigation.add(this.eltmenu_navigChoisirCivilisation);
        this.eltmenu_navigChoisirDate = new JMenuItem("Choisir une date...");
        this.menu_navigation.add(this.eltmenu_navigChoisirDate);
        this.eltmenu_navigChoisirCentre = new JMenuItem("Choisir une position...");
        this.menu_navigation.add(this.eltmenu_navigChoisirCentre);
        this.menu_affichage = this.menu("Affichage", 65);
        jMenuBar.add(this.menu_affichage);
        this.eltmenu_affFleuvesVisibles = new JCheckBoxMenuItem("Fleuves visibles", etatAppli.fleuvesAffiches());
        this.menu_affichage.add(this.eltmenu_affFleuvesVisibles);
        this.eltmenu_affMeridiensParallelesVisibles = new JCheckBoxMenuItem("M\u00e9ridiens & parall\u00e8les visibles", etatAppli.meridiensParallelesAffiches());
        this.menu_affichage.add(this.eltmenu_affMeridiensParallelesVisibles);
        this.eltmenu_affChoixLoupe = new JMenuItem("Choisir la loupe...");
        this.menu_affichage.add(this.eltmenu_affChoixLoupe);
        this.menu_options = this.menu("Options", 79);
        jMenuBar.add(this.menu_options);
        this.menu_deplacements = this.menu("D\u00e9placements", null);
        this.menu_options.add(jMenuBar.add(this.menu_deplacements));
        this.menu_deplAnnees = this.menuDeplAnnees();
        this.menu_deplacements.add(this.menu_deplAnnees);
        this.menu_deplEspace = this.menuDeplEspace();
        this.menu_deplacements.add(this.menu_deplEspace);
        this.menu_parametres = this.menu("Param\u00e8tres", null);
        this.menu_options.add(jMenuBar.add(this.menu_parametres));
        this.eltmenu_optMoletteGlisseDeUn = new JCheckBoxMenuItem("La molette d\u00e9place les glissi\u00e8res de 1 seulement", etatAppli.moletteGlisseDeUn());
        this.menu_parametres.add(this.eltmenu_optMoletteGlisseDeUn);
        this.eltmenu_optSymboleTracer = new JCheckBoxMenuItem("Afficher le symbole de tracer en cours", etatAppli.symboleAttenteTracer());
        this.menu_parametres.add(this.eltmenu_optSymboleTracer);
        this.eltmenu_optInfobullesCarte = new JCheckBoxMenuItem("Infobulles carte", etatAppli.infobullesCarte());
        this.menu_parametres.add(this.eltmenu_optInfobullesCarte);
        this.eltmenu_optTexteSurvolFondClair = new JCheckBoxMenuItem("Texte du territoire survol\u00e9 sur fond clair", etatAppli.texteSurvolFondClair());
        this.menu_parametres.add(this.eltmenu_optTexteSurvolFondClair);
        this.eltmenu_optSimpleClicFermerParagraphes = new JCheckBoxMenuItem("Un simple clic ferme la bo\u00eete de dialogue des paragraphes", etatAppli.simpleClicFermerParagraphes());
        this.menu_parametres.add(this.eltmenu_optSimpleClicFermerParagraphes);
        this.eltmenu_optAffParagraphesHtmlGeneres = new JCheckBoxMenuItem("Afficher le paragraphe html sauvegard\u00e9 pour v\u00e9rification", etatAppli.affParagraphesHtmlGeneres());
        this.menu_parametres.add(this.eltmenu_optAffParagraphesHtmlGeneres);
        this.menu_aide = this.menu("Aide", 69);
        jMenuBar.add(this.menu_aide);
        this.eltmenu_aidePresentation = new JMenuItem("Pr\u00e9sentation");
        this.menu_aide.add(this.eltmenu_aidePresentation);
        this.eltmenu_aideAPropos = new JMenuItem("A propos");
        this.menu_aide.add(this.eltmenu_aideAPropos);
        this.menuctx_deplAnnees = this.menuContextuelDeplAnnees();
        this.menuctx_deplEspace = this.menuContextuelDeplEspace();
        return jMenuBar;
    }

    private JMenu menu(String string, Integer n) {
        JMenu jMenu = new JMenu(string);
        if (n != null) {
            jMenu.setMnemonic(n);
        }
        return jMenu;
    }

    private JMenu menuDeplAnnees() {
        JMenu jMenu = new JMenu("Date");
        this.remplirMenuDeplAnnees(jMenu);
        return jMenu;
    }

    private JPopupMenu menuContextuelDeplAnnees() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.remplirMenuDeplAnnees(jPopupMenu);
        return jPopupMenu;
    }

    private void remplirMenuDeplAnnees(JComponent jComponent) {
        try {
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i = 0; i < EtatAppli.VALS_PAS_ANNEES.length; ++i) {
                int n = EtatAppli.VALS_PAS_ANNEES[i];
                String string = "" + n + " an" + (n == 1 ? "" : "s");
                EltMenuCoche eltMenuCoche = new EltMenuCoche(string, HistoireMondiale.instance().etat(), "iDeplAnnees", i);
                jComponent.add(eltMenuCoche);
                buttonGroup.add(eltMenuCoche);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Erreur lors de la cr\u00e9ation du menu d\u00e9placement ann\u00e9es", exception);
        }
    }

    private JMenu menuDeplEspace() {
        JMenu jMenu = new JMenu("Espace");
        this.remplirMenuDeplEspace(jMenu);
        return jMenu;
    }

    private JPopupMenu menuContextuelDeplEspace() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.remplirMenuDeplEspace(jPopupMenu);
        return jPopupMenu;
    }

    private void remplirMenuDeplEspace(JComponent jComponent) {
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < EtatAppli.VALS_PAS_ESPACE.length; ++i) {
            String string = "" + EtatAppli.VALS_PAS_ESPACE[i] + "\u00b0";
            EltMenuCoche eltMenuCoche = new EltMenuCoche(string, HistoireMondiale.instance().etat(), "iDeplEspace", i);
            jComponent.add(eltMenuCoche);
            buttonGroup.add(eltMenuCoche);
        }
    }

    public double posSeparateurPanneaux() {
        return (double)this.sp_panneauDeuxCotes.getDividerLocation() / (double)(this.sp_panneauDeuxCotes.getWidth() - this.sp_panneauDeuxCotes.getDividerSize());
    }

    public void majInfosTerritoireSurvole() {
        EtatAppli etatAppli = HistoireMondiale.instance().etat();
        Territoire territoire = etatAppli.territoireSurvole();
        if (territoire == null) {
            this.txt_infosTerritoireSurvole.setText("");
            this.txt_infosRoiTerritoireSurvole.setText("");
            this.txt_infosTerritoireSurvole.setVisible(false);
            this.txt_infosRoiTerritoireSurvole.setVisible(false);
        } else {
            String string;
            int n = etatAppli.annee();
            String string2 = territoire.nom().replace("$", " ");
            TexteTerritoire texteTerritoire = territoire.texteEn(n);
            String string3 = string2;
            String string4 = string = texteTerritoire == null ? "" : texteTerritoire.texte().replace("&", " ");
            if (etatAppli.texteSurvolFondClair()) {
                this.txt_infosTerritoireSurvole.setForeground(Color.BLACK);
                this.txt_infosTerritoireSurvole.setBackground(this.p_infos.getBackground());
                this.txt_infosRoiTerritoireSurvole.setForeground(Color.BLACK);
                this.txt_infosRoiTerritoireSurvole.setBackground(this.p_infos.getBackground());
                this.txt_infosTerritoireSurvole.setBorder(new BevelBorder(1));
                this.txt_infosRoiTerritoireSurvole.setBorder(new BevelBorder(1));
            } else {
                this.txt_infosTerritoireSurvole.setForeground(Color.WHITE);
                this.txt_infosTerritoireSurvole.setBackground(Color.BLACK);
                this.txt_infosRoiTerritoireSurvole.setForeground(Color.WHITE);
                this.txt_infosRoiTerritoireSurvole.setBackground(Color.BLACK);
                this.txt_infosTerritoireSurvole.setBorder(new BevelBorder(1, Color.BLACK, Color.GRAY));
                this.txt_infosRoiTerritoireSurvole.setBorder(new BevelBorder(1, Color.BLACK, Color.GRAY));
            }
            this.txt_infosTerritoireSurvole.setText(" " + string3 + " ");
            this.txt_infosRoiTerritoireSurvole.setText(" " + string + " ");
            this.txt_infosTerritoireSurvole.setVisible(true);
            this.txt_infosRoiTerritoireSurvole.setVisible(!string.trim().isEmpty());
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = (String)object;
        if ("territoireSurvole".equals(string)) {
            this.majInfosTerritoireSurvole();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n;
        EtatAppli etatAppli = HistoireMondiale.instance().etat();
        Object object = mouseWheelEvent.getSource();
        int n2 = (etatAppli.moletteGlisseDeUn() ? 1 : etatAppli.deplEspace()) * MULTIPLICATEUR_ESPACE;
        int n3 = n = etatAppli.moletteGlisseDeUn() ? 1 : etatAppli.deplAnnees();
        if (object == this.defil_longitudes) {
            this.defil_longitudes.setValue(this.defil_longitudes.getValue() + mouseWheelEvent.getWheelRotation() * n2);
        } else if (object == this.defil_latitudes) {
            this.defil_latitudes.setValue(this.defil_latitudes.getValue() + mouseWheelEvent.getWheelRotation() * n2);
        } else if (object == this.defil_annees) {
            this.defil_annees.setValeur(this.defil_annees.getValeur() + mouseWheelEvent.getWheelRotation() * n);
        } else {
            throw new IllegalStateException("Source inconnue : " + object);
        }
    }
}

