/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire.igraphique;

import fr.histoiremondiale.histoire.igraphique.actions.ActionsEspaceTemps;
import fr.histoiremondiale.histoire.igraphique.composants.Barre;
import fr.histoiremondiale.histoire.utiles.igraphique.swing.Fenetres;
import fr.histoiremondiale.histoire.utiles.math.PointSphere;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DialCentre
extends JDialog {
    private double longitude;
    private double latitude;
    private PointSphere centreInitial;
    private JLabel lbl;
    public Barre barreLongitude;
    public Barre barreLatitude;
    public JButton btnOK;
    public JButton btnAnnul;

    public DialCentre(JFrame jFrame, PointSphere pointSphere) {
        super(jFrame, "Centre", true);
        this.longitude = pointSphere.longitude();
        this.latitude = pointSphere.latitude();
        this.centreInitial = pointSphere;
        this.initComponent();
        this.pack();
        Fenetres.centrer(this, (Frame)jFrame);
        Fenetres.ajouterEcouteurEchapPourMasquer(this);
    }

    public DialCentre(JFrame jFrame, String string) {
        super(jFrame, string, true);
        this.centreInitial = new PointSphere(this.longitude, this.latitude);
        this.initComponent();
        this.pack();
        Fenetres.centrer(this, (Frame)jFrame);
        Fenetres.ajouterEcouteurEchapPourMasquer(this);
    }

    private void initComponent() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JPanel jPanel2 = new JPanel();
        this.lbl = new JLabel(this.centreInitial.enChaineElaboree());
        jPanel2.add(this.lbl);
        jPanel2.setBorder(BorderFactory.createTitledBorder("Valeur initiale"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.barreLongitude = new Barre(-180.0, 180.0, this.longitude);
        this.barreLongitude.setLargeur(80);
        jPanel3.add(this.barreLongitude);
        jPanel3.setBorder(BorderFactory.createTitledBorder("Longitude"));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this.barreLatitude = new Barre(-90.0, 90.0, this.latitude);
        this.barreLatitude.setLargeur(80);
        jPanel4.add(this.barreLatitude);
        jPanel4.setBorder(BorderFactory.createTitledBorder("Latitude"));
        JPanel jPanel5 = new JPanel();
        this.btnOK = new JButton("Valider");
        this.btnAnnul = new JButton("Annuler");
        jPanel5.add(this.btnOK);
        jPanel5.add(this.btnAnnul);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "East");
        jPanel.add((Component)jPanel4, "West");
        jPanel.add((Component)jPanel5, "South");
        this.getContentPane().add(jPanel);
    }

    public void afficher(PointSphere pointSphere) {
        this.longitude = pointSphere.longitude();
        this.latitude = pointSphere.latitude();
        this.centreInitial = pointSphere;
        this.barreLongitude.setValeur(this.longitude);
        this.barreLatitude.setValeur(this.latitude);
        this.setVisible(true);
    }

    public PointSphere getCentreInitial() {
        return this.centreInitial;
    }

    public void modifierLongitude() {
        this.longitude = this.barreLongitude.getValeur();
        this.lbl.setText(new PointSphere(this.longitude, this.latitude).enChaineElaboree());
        ActionsEspaceTemps.modifierLongitude(this.longitude);
    }

    public void modifierLatitude() {
        this.latitude = this.barreLatitude.getValeur();
        this.lbl.setText(new PointSphere(this.longitude, this.latitude).enChaineElaboree());
        ActionsEspaceTemps.modifierLatitude(this.latitude);
    }
}

