/*
 * Decompiled with CFR 0.152.
 */
package fr.histoiremondiale.histoire;

import fr.histoiremondiale.histoire.donnees.Civilisation;
import fr.histoiremondiale.histoire.donnees.Limes;
import fr.histoiremondiale.histoire.donnees.Territoire;
import fr.histoiremondiale.histoire.stockage.AccesDonneesHistoriques;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DonneesHistoriques {
    private Map<Integer, Limes> indexLimes;
    private List<Civilisation> civilisations;
    private List<Territoire> territoires;
    private Map<Integer, Civilisation> indexCivilisationsParId;
    private Map<String, Civilisation> indexCivilisationsParNom;
    private Map<Integer, Territoire> indexTerritoiresParId;
    private AccesDonneesHistoriques accesDonneesHistoriques;

    public DonneesHistoriques(AccesDonneesHistoriques accesDonneesHistoriques, Map<Integer, Limes> map) {
        long l = System.currentTimeMillis();
        this.accesDonneesHistoriques = accesDonneesHistoriques;
        this.indexLimes = map;
        this.civilisations = this.accesDonneesHistoriques.chargerCivilisations();
        this.indexCivilisationsParId = new HashMap<Integer, Civilisation>();
        for (Civilisation object : this.civilisations) {
            this.indexCivilisationsParId.put(object.id(), object);
        }
        this.indexCivilisationsParNom = new HashMap<String, Civilisation>();
        for (Civilisation civilisation : this.civilisations) {
            this.indexCivilisationsParNom.put(civilisation.nom(), civilisation);
        }
        this.territoires = this.accesDonneesHistoriques.chargerTerritoires(this.indexCivilisationsParId, this.indexLimes);
        this.indexTerritoiresParId = new HashMap<Integer, Territoire>();
        for (Territoire territoire : this.territoires) {
            this.indexTerritoiresParId.put(territoire.id(), territoire);
        }
        long l2 = System.currentTimeMillis();
        System.out.println("\t\tDonn\u00e9es historiques charg\u00e9es en " + (l2 - l) + " ms.");
        System.out.println("\t\t\tNombre de civilisations charg\u00e9es : " + this.civilisations.size());
        System.out.println("\t\t\tNombre de territoires charg\u00e9s    : " + this.territoires.size());
    }

    public Civilisation civilisationDId(int n) {
        return this.indexCivilisationsParId.get(n);
    }

    public Civilisation civilisationDeNom(String string) {
        return this.indexCivilisationsParNom.get(string);
    }

    public List<Civilisation> civilisationsTrieesParNom() {
        return this.civilisations;
    }

    public Territoire territoireParId(int n) {
        return this.indexTerritoiresParId.get(n);
    }

    public List<Territoire> territoiresAnnee(int n) {
        ArrayList<Territoire> arrayList = new ArrayList<Territoire>();
        for (Territoire territoire : this.territoires) {
            if (territoire.dateDebut() > n || n > territoire.dateFin()) continue;
            arrayList.add(territoire);
        }
        return arrayList;
    }

    public List<Territoire> territoires() {
        return this.territoires;
    }
}

